import java.math.BigDecimal;

enum SalaryBand  {
  BAND1(30000, 37000), BAND2(33000, 45000), BAND3(43000, 55000), BAND4(50000, 60000), 
  BAND5(57000, 70000), BAND6(67000, 80000), BAND7(77000, 90000), BAND8(88000, 100000), 
  BAND9(98000, 120000), BAND10(120000, 150000); 

  private BigDecimal lowerLimit;
  private BigDecimal upperLimit;

  public BigDecimal getLowerLimit() {return(lowerLimit);}
  public BigDecimal getUpperLimit() {return(upperLimit);}

  static SalaryBand getBand(BigDecimal valueToCheck) {
    //get the list of objects and check if the amount is in their bands
    for(SalaryBand x:SalaryBand.values())
    {
      BigDecimal lower = x.getLowerLimit(); 
      BigDecimal upper = x.getUpperLimit(); 
      if((valueToCheck.compareTo(lower)>=0) && (valueToCheck.compareTo(upper)<=0))
        return(x); //implicit exit from the method 
    }  
     //otherwise we don't have the number. Return null. 
     return(null);
  }

   private SalaryBand(int lower,int upper) {
     lowerLimit = new BigDecimal(lower);
     upperLimit = new BigDecimal(upper);
   } 
 } 