import java.nio.file.*;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class PracticeYourJava {
  public static void main(String[] args) {

    Map<String, String> env = new HashMap<>(); 
    env.put("create", "true");
    String zipName      = "zip01.zip";
    String fileToInsert = "abc.txt"; 

    Path targetPath = Paths.get(System.getProperty("user.home"), "Desktop", zipName); 

    try {	
      URI uri = URI.create("jar:file:" + targetPath.toUri().getPath());
      FileSystem zipFileSystem01 = FileSystems.newFileSystem(uri, env);
      Path inputFile = Paths.get(System.getProperty("user.home"), "Desktop", fileToInsert);
      Path pathInZipfile = zipFileSystem01.getPath(fileToInsert);
      //copy the file into the zip file 
      Files.copy(inputFile, pathInZipfile, StandardCopyOption.REPLACE_EXISTING );
      zipFileSystem01.close();
     }
    catch(IOException e){
      System.out.println("Could not put the file into zip directory");
      System.out.println(e.getStackTrace());
    }
  }
}