import java.nio.file.*;
import java.io.IOException;

public class PracticeYourJava {
  public static void main(String[] args) {

    String symLinkName = "lnk01";
    Path symlinkPath = Paths.get(System.getProperty("user.home"), symLinkName); 
    if(!(Files.isSymbolicLink(symlinkPath))){
      System.out.printf("%s itself is not a symbolic link, so nothing to detectExiting\n", 
          symlinkPath);
      System.exit(0);
    }
    Path actualTarget;
    try {
      actualTarget = Files.readSymbolicLink(symlinkPath);
      System.out.printf("%s is pointing to %s\n", symlinkPath, actualTarget);
    } catch (IOException e) {
      e.printStackTrace();
    }
  }
} 