import java.nio.file.*;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributes;

public class PracticeYourJava {
  public static void main(String[] args) {

    String dirName = "A/B"; 
    String pathSeparator = System.getProperty("file.separator");
    dirName = dirName.replace("/", pathSeparator);
    Path pathToDir = Paths.get(System.getProperty("user.home"), "Desktop", dirName);
   
    System.out.println("The target directory = " + pathToDir);

    FileVisitor<Path> fv = new SimpleFileVisitor<Path>(){ 
       //anonymous class used here...
       public FileVisitResult visitFile(Path pathItem, BasicFileAttributes attr) throws 
           IOException{ 
	      Files.delete(pathItem);
   	      return(FileVisitResult.CONTINUE);
	    }
       public FileVisitResult postVisitDirectory(Path pathItem, IOException e) throws IOException{
	  Files.delete(pathItem);		    	 
          return(FileVisitResult.CONTINUE);
       }
     };
    try{
      Files.walkFileTree(pathToDir, fv);
    } catch (IOException e1) {
	e1.printStackTrace();
    } 
  }
} 