import java.nio.file.*;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributes;

public class PracticeYourJava {
  public static void main(String[] args) {

    String dirName = "A"; 
    Path pathToDir = Paths.get(System.getProperty("user.home"), "Desktop", dirName);
    String pathSeparator = System.getProperty("path.separator");

    System.out.println("The target directory =" + pathToDir);
    FileVisitor<Path> fv = new SimpleFileVisitor<Path>() { 
      //we create an anonymous class here...good example of need for one.
      int count=0; //we use this to count how far down in the tree, for indentation 
      public FileVisitResult visitFile(Path pathItem, BasicFileAttributes attr) { 
	 if(count > 0) {
     	   for(int x=0;x<=(count+1);x++)
            System.out.print(" ");	
	 } 
        System.out.println(pathItem);
	 return(FileVisitResult.CONTINUE);
      }

     public FileVisitResult preVisitDirectory(Path pathItem, BasicFileAttributes attr) throws 
                 IOException {
	count++;
	if(count > 0) {
          for(int x=0;x<=count;x++)
	     System.out.print(" ");	
        } 
	System.out.println(pathItem+pathSeparator);
	return(FileVisitResult.CONTINUE);
     }
    };

    try{
      Files.walkFileTree(pathToDir, fv);
    } catch (IOException e) {
	e.printStackTrace();
    }
  }
}