import java.nio.file.*;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributes;

public class SimpleFileVisitor2 extends SimpleFileVisitor<Path> {

   public  int fileCount=0;
   public  int directoryCount=0;

    public FileVisitResult visitFile(Path pathItem, BasicFileAttributes attr){ 
      fileCount++;
      return(FileVisitResult.CONTINUE);
    }
    public FileVisitResult postVisitDirectory(Path pathItem, IOException e){
      directoryCount++;
      return(FileVisitResult.CONTINUE);
    }
}

public class PracticeYourJava {
  public static void main(String[] args) {

    String dirName = "A"; //The directory wed created on the desktop earlier 
    Path pathToDir = Paths.get(System.getProperty("user.home"), "Desktop", dirName); 

    System.out.println("The target directory =" + pathToDir);

    //Okay the new stuff to really pay attention to 
    SimpleFileVisitor2 sfv2 = new SimpleFileVisitor2();
    FileVisitor<Path> fv = sfv2;
    Files.walkFileTree(pathToDir, (FileVisitor<Path>)sfv2);
    System.out.println("File count      = " + sfv2.fileCount);
    System.out.println("Directory count = " + sfv2.directoryCount);
  }
}