import java.nio.file.*;
import java.io.IOException;

public class PracticeYourJava {
  public static void main(String[] args) {

    String oldFileName = "abc.txt";
    String newFileName = "def.txt";

    Path sourcePath = Paths.get(System.getProperty("user.home"), "Desktop", oldFileName); 
    Path targetPath = Paths.get(System.getProperty("user.home"), "Desktop", newFileName); 

    if(Files.notExists(sourcePath)){
      System.out.println("The source file does not exist. Exiting...");	
      System.exit(0);
    }
    if(Files.exists(targetPath)){
      System.out.println("A file with the same name already exists at the target location. 
            Exiting...");	
      System.exit(0);
    }
    if(!Files.isWritable(targetPath)){
      System.out.println("The target directory is not writeable. Exiting...");
    }
    //Now do the move 
    try {
      Files.move(sourcePath, targetPath);
    } catch (IOException e) {
      System.out.println("Error: Could not move the file");
      e.printStackTrace();
    }
    System.out.println("The move/rename has been done."); 
  }
}