import java.nio.file.*; 
import java.io.IOException;
import java.nio.file.attribute.UserPrincipal;

public class PracticeYourJava {
  public static void main(String[] args) {

    String fileName = "abc.txt"; 
    Path targetFile = Paths.get(System.getProperty("user.home"), "Desktop", fileName); 

    if(Files.notExists(targetFile)) {
      System.out.printf("The file %s does not exist. Exiting...\n", targetFile);
      System.exit(0);
    } 

    try {
      UserPrincipal owner = Files.getOwner(targetFile);
      System.out.printf("The owner of the file is: " + owner);
    } catch (IOException e) {
	e.printStackTrace();
    } 
  }
}