import java.nio.file.*; 
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributes;

public class PracticeYourJava {
  public static void main(String[] args) {

    String fileName = "abc.txt"; 
    Path targetFile = Paths.get(System.getProperty("user.home"), "Desktop", fileName); 

    if(Files.notExists(targetFile)) {
      System.out.printf("The file %s does not exist. Exiting...\n", targetFile);
      System.exit(0);
    }
    try {
      BasicFileAttributes bfa = Files.readAttributes(targetFile, BasicFileAttributes.class);
      System.out.println(bfa.creationTime());    	
      System.out.println(bfa.lastModifiedTime());
      System.out.println(bfa.lastAccessTime());
    } catch (IOException e) {
	e.printStackTrace();
    }   
  }
}