import java.nio.file.*; 
import java.io.IOException;
import java.nio.file.attribute.FileTime;

public class PracticeYourJava {
  public static void main(String[] args) {

    String fileName = "abc.txt"; 
    Path targetFile = Paths.get(System.getProperty("user.home"), "Desktop", fileName); 

    if(Files.notExists(targetFile)) {
      System.out.printf("The file %s does not exist. Exiting...\n", targetFile);
      System.exit(0);
    } 

    try {
      FileTime ft = Files.getLastModifiedTime(targetFile); 
      System.out.println("The last time the file was modified was: " + ft);
    }
    catch (IOException e) { 
      e.printStackTrace();
    } 
  }
}