import java.nio.file.*; 
import java.io.IOException;

public class PracticeYourJava {
  public static void main(String[] args) { 
    Iterable<Path> rootDirs = FileSystems.getDefault().getRootDirectories();
    for(Path rootDir: rootDirs) {
      try{
        FileStore fs = Files.getFileStore(rootDir);
	 double totalSpaceInMegs = (double)fs.getTotalSpace()/(double)(1024*1024);
	 System.out.println(rootDir);
	 System.out.printf("Total space = %.4f megs\n",totalSpaceInMegs);
	 double availSpaceInMegs = (double)(fs.getTotalSpace()-
	                  fs.getUnallocatedSpace())/(double)(1024*1024);
	 System.out.printf("Available space = %.4f megs\n",availSpaceInMegs);
	 System.out.println();  
      }      
      catch(FileSystemException e){
	 System.out.println(e.getMessage());
       }
      catch(IOException e){}
    } 
  }
}