import java.nio.file.*; 
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PracticeYourJava {
  public static void main(String[] args) {
    Path desktopPath = Paths.get(System.getProperty("user.home"), "Desktop"); 
    String pathSeparator = System.getProperty("path.separator");    

    List<Path> dirList = new ArrayList<>(); 
    // What we do in the 1st loop is to loop through the DirectoryStream object dirStream
    // and print out the files but put the directory Path objects into the ArrayList object
    // dirList; we print out the contents of dirList in the following loop.
    try{
      DirectoryStream<Path> dirStream = Files.newDirectoryStream(desktopPath);
      for (Path item: dirStream) {
        if(Files.isRegularFile(item))
	   System.out.println(item);
        else if(Files.isDirectory(item))
  	   dirList.add(item);
      }

      System.out.println();

      for (Path item: dirList){
       System.out.println(item+pathSeparator);
      }
      dirStream.close(); //make sure you close the stream
    }
    catch(IOException e){}
  }
}