import java.nio.file.*; 
import java.io.IOException; 

public class PracticeYourJava {
  public static void main(String[] args) {
    Path desktopPath = Paths.get(System.getProperty("user.home"), "Desktop"); 
    String pathSeparator = System.getProperty("path.separator");

    try{
      DirectoryStream<Path> dirStream = Files.newDirectoryStream(desktopPath);
      for (Path item: dirStream) {
        if(Files.isRegularFile(item))
          System.out.println("F-> "+item);
        else if(Files.isDirectory(item))
          System.out.println("D-> "+item+pathSeparator);
        else if(Files.isSymbolicLink(item))
           System.out.println("S-> "+item+pathSeparator);
        else 						
           System.out.println(item);
      }
      dirStream.close(); //make sure you close the stream
    }
    catch(IOException e){}
  }
}