import java.io.Serializable;
import java.util.ArrayList;

public class InterfacesAndCollections {

  public static void main(String[] args){

    Serializable ser01 = new ArrayList<Integer>();

    ((ArrayList<Integer>)ser01).add(27); 
     // Observe how we applied the cast ArrayList<Integer> to ser01 in order to see
     // the actual object ser01 referenced as it is indeed, an ArrayList<Integer>. 
     // When we apply the cast we can then apply the methods appropriate for
     // the casted type to it, such as the method ArrayList<T>.add that we  
     // applied here.

    for( Integer j: (ArrayList<Integer>)ser01 ) {
     //Again, we cast ser01 in the same way as previously done in order 
     //to see the object it references as an ArrayList<Integer>. 
      System.out.println(j);  // We print the variable out here 
    }
  }
}  