//REMEMBER TO PUT EACH CLASS/ENUM/INTERFACE INTO ITS OWN .java FILE.

import java.util.ArrayList;

public interface IGreeting { 
  default public void morningGreeting(){  //Note the keyword default in each of these 
                                      //methods
    System.out.println("Good morning!");	
  }
  default public void afternoonGreeting(){
    System.out.println("Good afternoon!");
  }

  default public void eveningGreeting(){
    System.out.println("Good evening!");
  }
}

public class Person{
  private String firstName;
  private String lastName;

  public Person(firstName,lastName){
    this.firstName = firstName;
    this.lastName = lastName; 
  } 
}

public class EnglishGreeter extends Person implements IGreeting {
  public EnglishGreeter(String firstName, String lastName) {
     super(firstName, lastName);
  }
}

public class FrenchGreeter extends Person implements IGreeting{

  public FrenchGreeter(String firstName, String lastName) {
    super(firstName, lastName);
  }
  public void morningGreeting(){
    System.out.println("Bonjour!");
  }
  public void afternoonGreeting(){
    System.out.println("Bon aprs-midi!");
  }
  public void eveningGreeting(){
    System.out.println("Bonne soire!");
  }
}

public class SpanishGreeter extends Person implements IGreeting{

  public SpanishGreeter(String firstName, String lastName) {
    super(firstName, lastName);
  }
  public void morningGreeting(){
    System.out.println("Buenos dias!");
  }
  public void afternoonGreeting(){
    System.out.println("Buenas tardes!");
  }
  public void eveningGreeting(){
    System.out.println("Buenas noches!");
  }
}

public class greeting {
  public static void main(String args[]){
    IGreeting englishGreeter  = new EnglishGreeter("Matthew","Charlis");
    IGreeting frenchGreeter   = new FrenchGreeter("Jacques","Gormand");
    IGreeting spanishGreeter  = new SpanishGreeter("Hernandez","Po");

    ArrayList<IGreeting> greeters = new ArrayList<>();
    greeters.add(englishGreeter); greeters.add(frenchGreeter); greeters.add(spanishGreeter);
    for(IGreeting m:greeters){
      m.morningGreeting(); 
    }
  } 
} 
