//PUT EACH CLASS HEREIN INTO ITS OWN SEPARATE .java file.

public abstract class Shape {

  private double length; 
  public abstract double area();
  public abstract double perimeter();
  public double getSideLength() {return(length);}

  public Shape(double length){ // constructor 
    this.length = length; 
  }
}

public class Circle extends Shape
{
  public  double area(){
    return (Math.PI * Math.pow(length, 2));
  }
  public  double perimeter(){
    return(this.circumference());
  }
  public double circumference(){
    return (2 * Math.PI * length);
  }

  public Circle(double x){super(x);}
}  
 
public class Square extends Shape
{
  public double area() {
    return (length * length);
  }
  public double perimeter() {
    return (length * 4);
  }

  public Square(double x){
    super(x);
  }
}
 	public class Triangle extends Shape
{
  public double area(){
    return((Math.sqrt(3)/(float)4) * 
            length*length);
  }
  public double perimeter(){
    return (length * 3);
  }

  public Triangle(double x){
    super(x);
  }
}
 
public class Pentagon extends Shape
{
  public  double area(){
   return(1.720477401 * Math.pow(length,2));
  }
  public  double perimeter(){
    return (length * 5);
  }
  public Pentagon(double x){
    super(x);
  }
}
public class Hexagon extends Shape
{
  public double area(){
    return(2.598076211 * Math.pow(length, 2));
  }
  public double perimeter(){
    return (length * 6);
  }
  public Hexagon(double x){ 
    super(x);
   }
}	

public class PracticeYourJava {
  public static void  main(String[] args) {
    Circle   obj1   = new Circle(2.73f);
    Square   obj2   = new Square(15);
    Pentagon obj3   = new Pentagon(5);
    Hexagon  obj4   = new Hexagon(3.7);

    ArrayList<Shape> shapeList = new ArrayList<>();
      
    shapeList.add(obj1); shapeList.add(obj2);
    shapeList.add(obj3); shapeList.add(obj4);
    for(Shape item:shapeList){
      System.out.println("Object class = " + item.getClass()); 
      System.out.println("Area         = " + item.area()); 
      System.out.println("Perimeter    = " + item.perimeter()); 
      System.out.println();
    }
  }
}