import java.math.BigDecimal;
import java.math.RoundingMode;

public class Employee {
  private String firstName;
  private String lastName;
   
  private SalaryHistory[] salaryHistory = new SalaryHistory[100];
  // We use 100 just set to a reasonable number
  private int insertionCounter=0; //counter for the  array above 
  
  public Employee(String firstName, String lastName) {
    this.firstName = firstName;
    this.lastName  = lastName;
  }

  public void addToSalaryHistory(int numberOfMonths, String amount){
    SalaryHistory sh = new SalaryHistory();
    sh.numberOfMonths = numberOfMonths;
    sh.amount = new BigDecimal(amount);
    salaryHistory[insertionCounter] = sh;
    insertionCounter+=1;
  }

  public BigDecimal averageSalary(){
    if(insertionCounter==0) return(new BigDecimal("0"));
      int totalNumberOfMonths=0;
      BigDecimal runningTotal = new BigDecimal("0");
      for(int count=0; count < insertionCounter; count++)
      {
        BigDecimal aggregateForPeriod = (salaryHistory[count].amount).multiply(new 
                                   BigDecimal(salaryHistory[count].numberOfMonths));
	 runningTotal = runningTotal.add(aggregateForPeriod); 
	 totalNumberOfMonths+= salaryHistory[count].numberOfMonths;
      }
    BigDecimal averageSalary = runningTotal.divide(new BigDecimal(totalNumberOfMonths), 
                                                    RoundingMode.HALF_UP);
    return(averageSalary);
  }

  class SalaryHistory{
    int numberOfMonths;
    BigDecimal amount; 
  }
	
  public static void main(String[] args) {
    Employee emp01 = new Employee("Tabitha","Gump");
    emp01.addToSalaryHistory(3, "3000"); 
    emp01.addToSalaryHistory(9, "3500");
    emp01.addToSalaryHistory(12, "4000");
    emp01.addToSalaryHistory(5, "4500");
    System.out.println("The average monthly salary of " + emp01.firstName + " " + emp01.lastName + " = " + emp01.averageSalary());
  }
}