public class Alphabet{

  private String alphabetName; 
  private int numberOfLetters; // number of letters this alphabet has 
  private Letter[] letters;    // We can do a forward reference to the inner class Letter
// which we will declare later in this class 
// that will be declared later in the body of this 
  private int lettersIndex=0;  // number of "letters" entered so far

  protected Alphabet(String alphabetName, int numberOfLetters){ //Constructor
    // We create an array of inner class Letter for as many characters as this 
    // alphabet contains. 
    this.alphabetName = alphabetName;
    this.numberOfLetters = numberOfLetters; 
    letters = new Letter[numberOfLetters]; //instantiate the array letters  
  }

  public void printAlphabet(){
    if(lettersIndex == 0) return;
    System.out.println("Alphabet Name=" + alphabetName);
    System.out.println("Expected # of characters in this alphabet = " + numberOfLetters);
    System.out.println("Currently entered # of characters = " + lettersIndex +"\n");
    for(int j=0; j < lettersIndex; j++)
    System.out.printf("Letter=%s Pronunciation=%s\n", letters[j].letterName,
letters[j].pronunciationDescription); 
  }

  public class Letter{ //the inner class 
    String letterName;
    String pronunciationDescription;

    Letter(String name, String description){ //Constructor of the inner class 
      letterName = name; 
      pronunciationDescription = description; 
    }

    void addToOuterObjectList(){
      Alphabet.this.letters[lettersIndex] = this;
      lettersIndex++;
    }

  } //End inner class Letter 

}//End outer class 

public class testAlphabet {

  public static void main(String args[]){
    Alphabet roman = new Alphabet("Roman",26);
    Alphabet.Letter letter_A = roman.new Letter("A","Ayyyy");
    Alphabet.Letter letter_B = roman.new Letter("B","Beeee"); 
    letter_A.AddToOuterObjectList();
    letter_B.AddToOuterObjectList();

    roman.printAlphabet();
  }
}
