//REMEMBER TO PUT EACH CLASS/ENUM/INTERFACE INTO ITS OWN .java FILE.

public abstract class Shape {

  private double length; 
  public abstract double area();
  public abstract double perimeter();
  public double getSideLength() {return(length);}

  public Shape(double length){ // constructor 
    this.length = length; 
  }
}

public class Circle extends Shape
{
  public  double area(){
    return (Math.PI * Math.pow(length, 2));
  }
  public  double perimeter(){
    return(this.circumference());
  }
  public double circumference(){
    return (2 * Math.PI * length);
  }

  public Circle(double x){super(x);}
}  
 
public class Square extends Shape
{
  public double area() {
    return (length * length);
  }
  public double perimeter() {
    return (length * 4);
  }

  public Square(double x){
    super(x);
  }
}
 	public class Triangle extends Shape
{
  public double area(){
    return((Math.sqrt(3)/(float)4) * 
            length*length);
  }
  public double perimeter(){
    return (length * 3);
  }

  public Triangle(double x){
    super(x);
  }
}
 
public class Pentagon extends Shape
{
  public  double area(){
   return(1.720477401 * Math.pow(length,2));
  }
  public  double perimeter(){
    return (length * 5);
  }
  public Pentagon(double x){
    super(x);
  }
}
public class Hexagon extends Shape
{
  public double area(){
    return(2.598076211 * Math.pow(length, 2));
  }
  public double perimeter(){
    return (length * 6);
  }
  public Hexagon(double x){ 
    super(x);
   }
}	

public class PracticeYourJava {
  public static void  main(String[] args) {

    Circle   obj1 = new Circle(2.73f); Square   obj2 = new Square(15);
    Pentagon obj3 = new Pentagon(5);   Hexagon  obj4 = new Hexagon(3.7);
  
    Shape[] shapeArray = new Shape[4];
    shapeArray[0]=obj1; shapeArray[1]=obj2;
    shapeArray[2]=obj3; shapeArray[3]=obj4;
    for(int j=0; j < shapeArray.length; j++)
      System.out.println("[%d] = %s\n", j, shapeArray[j].getClass()); 
  } 
}