public class ConsoleHandling {

  public static void main(String[] args){
    long sum = 0;
    int numOfIntegers = 0;

    if(args.length == 0 ){
      System.out.println("No arguments passed. Exiting");
      System.exit(0);
    }
    for (int i = 0; i < args.length; i++){
      long potentialInteger;
      try{
        potentialInteger = Long.parseLong(args[i]);
        sum+=potentialInteger; 
        numOfIntegers++;
      }
      catch(NumberFormatException e){
        //Ignore the non-numbers
      }
    }
    System.out.printf("Total = %d\n", sum);
    System.out.printf("Number of integers = %d\n", numOfIntegers);
    System.out.printf("Number of args     = %d\n", args.length);
  }
}