import java.io.Console;

public class ConsoleHandling {
  public static void main(String[] args){
    Console consoleObject = System.console();
    if(consoleObject==null){
      System.out.println("A console object was not obtained successfully...exiting");
      System.exit(0);
    }

   String tempScale=""; 
   System.out.print("Enter temperature:");
   String sInput = consoleObject.readLine();
   sInput = sInput.toLowerCase();
   if(sInput.contains("f"))
     tempScale = "f";
   else if (sInput.contains("c"))
     tempScale = "c";
   else{
     System.out.print("You have to specify C or F");
     System.exit(0);
   }
 
  //Now extract only the number value from the temperature
  //do that by getting rid of "f", "c" and " "
  sInput = sInput.replace("f","");
  sInput = sInput.replace("c","");
  sInput = sInput.replace(" ","");
  double d01=0;

  try{
    d01 = Double.valueOf(sInput);
  }
  catch(NumberFormatException e){
    System.out.println("The value entered is not a valid numerical value...exiting...");
    System.exit(0);
  }

  if (tempScale.contentEquals("f")){
    System.out.printf("Equivalent temp = %fC", (d01 - 32) * ((float)5 / (float)9));
  }
  else
    System.out.printf("Equivalent temp = %fF", (d01 * (float)9 / (float)5) + 32); 
  }
}