import java.time.*; 

public class PracticeYourJava {
  public static void main(String[] args) {

    //measuring duration of array sorting, using Instant & Duration 
    int numElements =  20_000_000;
    int[] array01 = new int[numElements];
    int[] array02; //we will copy array01 to this after we've filled array01 with random numbers

    for(int i=0;i<array01.length;i++)
      array01[i] = (int)Math.ceil(Math.random() * 10000);

    array02 = Arrays.copyOf(array01, array01.length); //make a copy to use for the other algorithm 

    // The 2nd sort, using Arrays.Sort 
    Instant startInstant = Instant.now();
    Arrays.sort(array01); 
    Instant finishInstant = Instant.now(); 
    Duration duration01 = Duration.between(startInstant,finishInstant);
    System.out.println("Using Arrays.sort: time to sort: " + numElements + " = " + duration01); 

    // The 2nd sort, using Arrays.parallelSort 
    startInstant = Instant.now();
    Arrays.parallelSort(array02);
    finishInstant = Instant.now();
    duration01 = Duration.between(startInstant,finishInstant);
    System.out.println("Using Arrays.parallelSort: time to sort:  " + numElements + " = " +  duration01); 
  }
}